// PortDDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PortD.h"
#include "PortDDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPortDDlg dialog

CPortDDlg::CPortDDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPortDDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPortDDlg)
	m_Status = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPortDDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPortDDlg)
	DDX_Control(pDX, IDC_STOP, m_Stop);
	DDX_Control(pDX, IDC_ENABLE_PORTD, m_Enable);
	DDX_Text(pDX, IDC_PORT_STATUS, m_Status);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPortDDlg, CDialog)
	//{{AFX_MSG_MAP(CPortDDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_OPEN_DRIVER, OnOpenDriver)
	ON_BN_CLICKED(IDC_ENABLE_PORTD, OnEnablePortd)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_STOP, OnStop)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPortDDlg message handlers

BOOL CPortDDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
    // set our points equal to something.....
	m_pSR=NULL;
    m_driverInstance=NULL;
	m_pSR1=NULL;
    m_driverInstance1=NULL;
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPortDDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPortDDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPortDDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CPortDDlg::OnOpenDriver() 
{
	/*
  This example was written in MSVC++ 6.0 Standard Edition
  in Win2K SP1 with 3140-850A02 DriverLINX driver for KPCI-3140.

  This example shows how make use of the edge detection feature of 
  digital Port D of the KPCI-3140.

  This example requires the use of Windows messaging to intercept
  the TimerTic messages from DriverLINX which will indicate to the 
  application that an edge has occured.  

  Two Service Requests are used so that two bits of Port D can
  independently be operated.  Each of these two tasks has a unique
  task ID.  The message sent by DriverLINX will identify which task is
  generating the message.  This task ID is within the lParam parameter
  of the message.

  This example shows how to test for which task has sent the message.

  To use all 8bits, 8 SR structures would need to be declared.

*/

	   // Open the driver and Initialize the hardware

// pass in driver name to avoid the Open DriverLINX Dialog
m_driverInstance=OpenDriverLINX(m_hWnd,"kpci3140"); //Open DriverLINX driver, and bring up the dialog box to pick a driver
m_pSR=(DL_ServiceRequest*) new (DL_ServiceRequest); //get a pointer to the service request
memset(m_pSR,0,sizeof(DL_ServiceRequest)); //Initialize the members of the service request
DL_SetServiceRequestSize(*m_pSR); //Need to set the service request size member
m_pSR->device=0; //set the device number (DriverLINX Config Panel setting)
m_pSR->operation=INITIALIZE; //Need to initialize the device before we can use it
m_pSR->subsystem=DEVICE;  //the initialize function is part of the DEVICE subsystem
m_pSR->mode=OTHER;  //Initialize is not a polled, interrupt, or dma operation, so we use OTHER
m_pSR->hWnd=m_hWnd;  //Need to set the hWnd member to the window handle of the application
//Execute the initialize service
 //show any errors	

if (DriverLINX(m_pSR) == NoErr)
{
	// success
m_Enable.EnableWindow(TRUE);  // enable the Sample button
UpdateData(FALSE);
m_DLmsg=RegisterWindowMessage(DL_MESSAGE);  // get a safe offset for our DriverLINX messages
}
else
{  // problem has occured
showMessage(m_pSR);  // display the error message box

}


// Open the driver and Init the second SR structure:


// pass in driver name to avoid the Open DriverLINX Dialog
m_driverInstance1=OpenDriverLINX(m_hWnd,"kpci3140"); //Open DriverLINX driver, and bring up the dialog box to pick a driver
m_pSR1=(DL_ServiceRequest*) new (DL_ServiceRequest); //get a pointer to the service request
memset(m_pSR1,0,sizeof(DL_ServiceRequest)); //Initialize the members of the service request
DL_SetServiceRequestSize(*m_pSR1); //Need to set the service request size member
m_pSR1->device=0; //set the device number (DriverLINX Config Panel setting)
m_pSR1->hWnd=m_hWnd;
// no need to init the same board a second time.....

// set focus back to our dialog
CWnd::SetActiveWindow();		
	
}

void CPortDDlg::OnEnablePortd() 
{
	// setup the Service Request to send messages in response to
	// an edge at bit 0 of Port D
/*
    Set up a task for bit 0 using m_pSR
*/

	m_pSR->operation=START;
	m_pSR->subsystem=CT;
	m_pSR->mode=INTERRUPT;
	m_pSR->start.typeEvent=COMMAND;
	m_pSR->stop.typeEvent= COMMAND; //Remain active until the stop button is pressed
	m_pSR->timing.typeEvent=DIEVENT;
	m_pSR->timing.u.rateEvent.channel=DI_EXTCLK; //
	m_pSR->timing.u.diEvent.mask = 1;  // 1 = bit 0
	m_pSR->timing.u.diEvent.match = FALSE;
	m_pSR->timing.u.diEvent.pattern = 1;  // 1 = Falling Edge, 0 = Rising Edge
	
	DriverLINX(m_pSR); //Start the waveform
	showMessage(m_pSR); //show any errors

	m_taskID=m_pSR->taskId; //Need to save the task ID so we can identify it later
	                        // in the TimerTic message

/*
    Set up a task for bit 1 using m_pSR1
*/

	m_pSR1->operation=START;
	m_pSR1->subsystem=CT;
	m_pSR1->mode=INTERRUPT;
	m_pSR1->start.typeEvent=COMMAND;
	m_pSR1->stop.typeEvent= COMMAND; //Remain active until the stop button is pressed
	m_pSR1->timing.typeEvent=DIEVENT;
	m_pSR1->timing.u.rateEvent.channel=DI_EXTCLK; //
	m_pSR1->timing.u.diEvent.mask = 2;  // 2 = bit 1
	m_pSR1->timing.u.diEvent.match = FALSE;
	m_pSR1->timing.u.diEvent.pattern = 0;  // 1 = Falling Edge, 0 = Rising Edge
	
	DriverLINX(m_pSR1); //Start the waveform
	showMessage(m_pSR1); //show any errors

	m_taskID_bit1=m_pSR1->taskId;  // store the task ID of the second SR

m_Stop.EnableWindow(TRUE);  // enable the Stop button
m_Enable.EnableWindow(FALSE);  // disable the Start button
m_Status.Format("%s","Waiting for edge to occur at bit 0 or bit 1 of Port D....");
UpdateData(FALSE); //update the dialog

	
}

void CPortDDlg::OnClose() 
{
		// code to clean up after DriverLINX
if (m_driverInstance != NULL)
{
   CloseDriverLINX(m_driverInstance); //close the DriverLINX driver
   m_driverInstance=NULL; //make sure m_driverInstance isn't pointing to anything
}
if (m_pSR != NULL)
{

   delete(m_pSR); //de-allocate the memory used by the service request
   m_pSR=NULL;
}


// now do same for the second Service Request:
if (m_driverInstance1 != NULL)
{
   CloseDriverLINX(m_driverInstance1); //close the DriverLINX driver
   m_driverInstance1=NULL; //make sure m_driverInstance isn't pointing to anything
}
if (m_pSR1 != NULL)
{

   delete(m_pSR1); //de-allocate the memory used by the service request
   m_pSR1=NULL;
}

	
	CDialog::OnClose();
}

void CPortDDlg::showMessage(DL_ServiceRequest *SR)
{
	SR->operation=MESSAGEBOX;
	DriverLINX(SR);
/*
// the code below could be used instead of the messagebox operation above

char errString[100];
DWORD size=50;
int errNumber;
errNumber = getErrCode(SR->result);
// errNumber corresponds to DriverLINX documentation
ReturnMessageString(SR->hWnd,SR->result,errString,size);
// errString corresponds to DriverLINX documentation
m_errMsg.Format("%s",errString);  // would need to add a static text called m_errMsg to dialog
UpdateData(FALSE);  // update the dialog
*/

	return;
}

LRESULT CPortDDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	// TODO: Add your specialized code here and/or call the base class

	// this is the "message pump"
	// need to see if the message is from DriverLINX and then if so
	// which one.  Will decode the info in LPARAM
	if(message == m_DLmsg) //Check for DriverLINX message
	{
		switch(wParam)
		{
		case DL_TIMERTIC: //Check for which task is responsible for this TimerTic message
			WORD taskID;
			taskID = getTaskId(lParam);  // this is a DriverLINX macro to decode the info
			if (m_taskID == taskID)
			{
			      m_Status.Format("%s","Edge at bit 0 has occurred....");
			      UpdateData(FALSE); //update the dialog
			} 
			if (m_taskID_bit1 == taskID)
			
			{
				m_Status.Format("%s","Edge at bit 1 has occurred...");
				UpdateData(FALSE); //update the dialog
			}

			break;
        case DL_SERVICEDONE:
            m_Status.Format("%s","Task is inactive....");
			UpdateData(FALSE); //update the dialog
			break;
		}
	}


	// pass the message along in case it was not from DriverLINX
	return CDialog::WindowProc(message, wParam, lParam);
}

void CPortDDlg::OnStop() 
{
	// TODO: Add your control notification handler code here
/*
  if we do a STOP operation on a task that does not exist, an error will result.
  this app does not do any error checking for this condition.
*/
// stop first task
m_pSR->taskId = m_taskID;
m_pSR->operation=STOP;	
DriverLINX(m_pSR);
// stop second task
m_pSR1->taskId = m_taskID_bit1;
m_pSR1->operation=STOP;	
DriverLINX(m_pSR1);
//  would be "active task not found" error if no active task existed
//  But it does not kill us.
m_Stop.EnableWindow(FALSE);  // disable the Stop button
m_Enable.EnableWindow(TRUE);  // enable the Start button	
}
